<?php
// Inclui as funções necessárias
require_once("includes/functions.php");

// Inicializa variáveis
$isStream = false;
$username = $password = $forwardPath = '';

// Função para validar e obter os parâmetros de entrada
function getUserParams()
{
    $params = [
        'username' => '',
        'password' => '',
    ];

    // Verificar se os parâmetros GET ou POST estão presentes e retornar de forma segura
    if (isset($_GET['username'], $_GET['password'])) {
        $params['username'] = filter_var($_GET['username'], FILTER_SANITIZE_STRING);
        $params['password'] = filter_var($_GET['password'], FILTER_SANITIZE_STRING);
    } elseif (isset($_POST['username'], $_POST['password'])) {
        $params['username'] = filter_var($_POST['username'], FILTER_SANITIZE_STRING);
        $params['password'] = filter_var($_POST['password'], FILTER_SANITIZE_STRING);
        $params['forwardPath'] = "?" . http_build_query($_POST);
    } elseif (isset($_GET['path'])) {
        $isStream = true;
        $parts = explode("/", $_GET['path']);
        if (count($parts) > 1) {
            $params['username'] = $parts[0];
            $params['password'] = $parts[1];
        }
    }

    return $params;
}

// Função para verificar e salvar o DNS
function checkAndSaveDNS($dns, $username, $password)
{
    $portal = rtrim($dns['portal'], '/');
    $ok = false;

    // Se o DNS não foi checado, faz a verificação
    if (!$dns['checked']) {
        $checkUrl = $portal . "/player_api.php?username=" . $username . "&password=" . $password;
        $callResult = callApi($checkUrl);
        $result = json_decode($callResult["data"]);

        if ($result && $callResult["result"] == "success" && isset($result->user_info->auth) && $result->user_info->auth != 0 && $result->user_info->status == "Active") {
            saveDNSForUser($dns['id'], $username, $password);
            $ok = true;
        }
    } else {
        // DNS já checado, então apenas salva
        saveDNSForUser($dns['id'], $username, $password);
        $ok = true;
    }

    return $ok;
}

// Função para processar o stream
function processStream($portalUrl, $isStream)
{
    $result = callApi($portalUrl, $isStream, $isStream ? 'VLC/3.1.21-rc2 LibVLC/3.1.21-rc2' : '');

    if ($isStream) {
        if (isset($result['headers']['Location'])) {
            header("Location: " . $result['headers']['Location'], true, 301);
            exit;
        } else {
            echo $result['data'];
            exit;
        }
    } else {
        echo $result['data'];
        exit;
    }
}

// Função para carregar as informações de DNS para o usuário
function loadDNSForUser($username, $password)
{
    $dnsInfo = [];
    $db = new SQLite3('./.boxbrdb.db');  // Substitua pelo caminho correto do seu banco de dados
    if ($db) {
        // Preparando a consulta para pegar os dados de DNS associados ao usuário
        $stmt = $db->prepare("SELECT dns.id, dns.portal, dns.checked 
                              FROM dns 
                              JOIN user_dns ON user_dns.dns_id = dns.id 
                              JOIN users ON users.id = user_dns.user_id 
                              WHERE users.username = :username AND users.password = :password");
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $stmt->bindValue(':password', $password, SQLITE3_TEXT);
        
        $result = $stmt->execute();
        
        while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
            $dnsInfo[] = $row;
        }
        
        $db->close();
    }
    return $dnsInfo;
}

// Função para salvar o DNS para o usuário
function saveDNSForUser($dnsId, $username, $password)
{
    $db = new SQLite3('./.boxbrdb.db');  // Substitua pelo caminho correto do seu banco de dados
    if ($db) {
        // Primeiro, verificar se o usuário já está associado ao DNS
        $stmt = $db->prepare("SELECT * FROM user_dns WHERE user_id = (SELECT id FROM users WHERE username = :username AND password = :password) AND dns_id = :dnsId");
        $stmt->bindValue(':username', $username, SQLITE3_TEXT);
        $stmt->bindValue(':password', $password, SQLITE3_TEXT);
        $stmt->bindValue(':dnsId', $dnsId, SQLITE3_INTEGER);
        
        $result = $stmt->execute();
        $existingRecord = $result->fetchArray(SQLITE3_ASSOC);
        
        if (!$existingRecord) {
            // Se não existir um vínculo entre o usuário e o DNS, vamos criar um novo
            $stmt = $db->prepare("INSERT INTO user_dns (user_id, dns_id) VALUES 
                                  ((SELECT id FROM users WHERE username = :username AND password = :password), :dnsId)");
            $stmt->bindValue(':username', $username, SQLITE3_TEXT);
            $stmt->bindValue(':password', $password, SQLITE3_TEXT);
            $stmt->bindValue(':dnsId', $dnsId, SQLITE3_INTEGER);
            
            $stmt->execute();
        }

        $db->close();
    }
}

// Carrega os parâmetros do usuário
$params = getUserParams();
$username = $params['username'];
$password = $params['password'];
$forwardPath = $params['forwardPath'];
$isStream = $isStream ?? false;  // Define a variável $isStream

// Carrega as informações de DNS para o usuário
$dnsInfo = loadDNSForUser($username, $password);

// Processa cada DNS carregado para verificar a autenticidade e disponibilidade do stream
foreach ($dnsInfo as $dns) {
    if (checkAndSaveDNS($dns, $username, $password)) {
        // Se for um stream, redireciona ou exibe o conteúdo
        $portalUrl = rtrim($dns['portal'], '/') . $forwardPath;
        processStream($portalUrl, $isStream);
    }
}

echo "Erro: DNS não verificado ou falha no processo.";
?>
